# Simulation C – Collisional Decoherence (Present‑Act V2.1)

This repository implements **Simulation C** of the Present‑Act V2.1 programme.
It extends the boolean/ordinal engine used previously by introducing a
simple which‑path marking instrument to model collisional decoherence.

At each of \(N\) discrete “opportunities” along a history, a mark can
occur with probability \(p\).  If a mark occurs the history’s path
identity is recorded, and at the screen this history’s fringe
contribution is forced to be phase‑neutral (it is split equally
between the constructive and destructive ROIs regardless of its
geometric phase).  Unmarked histories retain their phase and
contribute to interference.  The visibility thus attenuates as
\(V/V_0 = (1-p)^N\), approaching \(\exp(-p N)\) for small \(p\) and
large \(N\).

The simulation sweeps \(p\in\{0.0, 0.02, 0.05, 0.10, 0.20\}\) and
\(N\in\{10, 20, 40, 80\}\) and measures the fringe visibility ratio
\(V/V_0\).  It demonstrates that the ratio follows the predicted
exponential law and that violating the present‑act invariants (e.g.,
using a continuous tiebreak, allowing skip moves, or ignoring marks at
readout) breaks the expected behaviour.

## Layout

```
pa_v2_simC/
├── README.md              # this file
├── env/
│   └── environment.yml    # conda environment specification
├── seeds.yaml             # global seeds [101, 202, 303]
├── engine/                # boolean/ordinal engine (copied from Sim‑A)
│   ├── accept.py
│   ├── gates.py
│   ├── tie_kernel.py
│   ├── rng.py
│   └── lattice.py
├── instruments/
│   └── marks.py           # mark row generator and mark counting
├── sim/
│   ├── manifest.yaml      # experiment configuration
│   └── run.py             # driver script
├── analysis/
│   ├── metrics.py         # RMSE, slopes, regression metrics
│   └── plots.py           # generate log‑slope and collapse figures
└── results/
    ├── raw/               # CSVs will be written here
    └── figs/              # figures will be written here
```

## Quick start

```
conda env create -f env/environment.yml
conda activate pa_v2_simC

# run the sweep (baseline + ablations)
python sim/run.py --manifest sim/manifest.yaml

# generate the plots
python analysis/plots.py --summary results/raw/simC_summary.csv --output_dir results/figs --ablation results/raw/simC_ablation.csv
```

## Notes

- **Which‑path marks.**  Mark opportunities are placed every 3 rows
  starting three rows after the slits.  For each row, with
  probability \(p\) we record which slit the history passes through.
  Once a mark occurs, the history’s phase is neutralised at readout
  (it is split 50/50 between constructive and destructive ROIs).  Marks
  are an instrument only: they do not influence acceptance or
  feasibility.
- **Baseline.**  The case \(p=0\) provides the baseline visibility
  \(V_0\) for each \(N\) and seed.  When \(p>0\) the measured
  visibility \(V\) is compared to this baseline to form the ratio
  \(V/V_0\).
- **Predictions.**  The expected ratio is \(V/V_0 = (1-p)^N\).  For
  small \(p\) and large \(N\) this approximates \(\exp(-p N)\).  The
  analysis and plots verify this relationship and quantify deviations.
- **Ablations.**  Three falsifications are included: (1) using a
  continuous tiebreak (ties‑off), (2) permitting skip moves/diagonals
  in the lattice, and (3) ignoring marks at readout (negative
  control).  Each ablation is expected to break the predicted
  exponential attenuation or remove it entirely.
